within ModelicaTest;
package Blocks "Test models for Modelica.Blocks"
  extends Modelica.Icons.ExamplesPackage;
  model Continuous
    extends Modelica.Icons.Example;
    Modelica.Blocks.Continuous.Integrator integrator annotation (Placement(
          transformation(extent={{-60,100},{-40,120}}, rotation=0)));
    Modelica.Blocks.Continuous.LimIntegrator limIntegrator(outMax=1)
      annotation (Placement(transformation(extent={{-60,60},{-40,80}}, rotation=
             0)));
    Modelica.Blocks.Continuous.Derivative derivative(x_start=0, initType=
          Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
          transformation(extent={{-60,20},{-40,40}}, rotation=0)));
    Modelica.Blocks.Continuous.FirstOrder firstOrder(T=1, initType=Modelica.Blocks.Types.Init.InitialState)
      annotation (Placement(transformation(extent={{-60,-20},{-40,0}}, rotation=
             0)));
    Modelica.Blocks.Continuous.SecondOrder secondOrder(
      w=1,
      D=1,
      initType=Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
          transformation(extent={{-60,-60},{-40,-40}}, rotation=0)));
    Modelica.Blocks.Continuous.PI pI(T=1, initType=Modelica.Blocks.Types.Init.InitialState)
      annotation (Placement(transformation(extent={{-60,-100},{-40,-80}},
            rotation=0)));
    Modelica.Blocks.Continuous.PID pID(
      Ti=0.5,
      Td=0.1,
      initType=Modelica.Blocks.Types.InitPID.InitialState) annotation (
        Placement(transformation(extent={{-60,-140},{-40,-120}}, rotation=0)));
    Modelica.Blocks.Continuous.LimPID limPID(
      Ti=0.5,
      Td=0.1,
      yMax=1,
      initType=Modelica.Blocks.Types.InitPID.InitialState) annotation (
        Placement(transformation(extent={{40,100},{60,120}}, rotation=0)));
    Modelica.Blocks.Continuous.TransferFunction transferFunction(
      a={1,1},
      b={1},
      initType=Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
          transformation(extent={{40,20},{60,40}}, rotation=0)));
    Modelica.Blocks.Continuous.StateSpace stateSpace(
      A=[1, 0; 0, 1],
      B=[1; 1],
      C=[1, 1],
      initType=Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
          transformation(extent={{40,-20},{60,0}}, rotation=0)));
    Modelica.Blocks.Continuous.LowpassButterworth lowpassButterworth(f=1,
        initType=Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
          transformation(extent={{40,-60},{60,-40}}, rotation=0)));
    Modelica.Blocks.Continuous.CriticalDamping criticalDamping(
      normalized=false,
      f=1,
      initType=Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
          transformation(extent={{40,-100},{60,-80}}, rotation=0)));
    Modelica.Blocks.Sources.Ramp ramp(
      offset=0.5,
      startTime=0.5,
      duration=2) annotation (Placement(transformation(extent={{-100,100},{-80,
              120}}, rotation=0)));
    Modelica.Blocks.Sources.Ramp ramp1(
      offset=0.5,
      startTime=0.5,
      duration=2) annotation (Placement(transformation(extent={{0,100},{20,120}},
            rotation=0)));
    Modelica.Blocks.Sources.Constant const(k=1.5) annotation (Placement(
          transformation(
          origin={50,70},
          extent={{-10,-10},{10,10}},
          rotation=90)));
    Modelica.Blocks.Continuous.Der der1 annotation (Placement(transformation(
            extent={{40,-140},{60,-120}}, rotation=0)));
    Modelica.Blocks.Sources.Sine sine(freqHz=1) annotation (Placement(
          transformation(extent={{0,-140},{20,-120}}, rotation=0)));
  equation
    connect(ramp.y, integrator.u)
      annotation (Line(points={{-79,110},{-62,110}}, color={0,0,127}));
    connect(ramp.y, limIntegrator.u) annotation (Line(points={{-79,110},{-72,
            110},{-72,70},{-62,70}}, color={0,0,127}));
    connect(ramp.y, derivative.u) annotation (Line(points={{-79,110},{-72,110},
            {-72,30},{-62,30}}, color={0,0,127}));
    connect(ramp.y, firstOrder.u) annotation (Line(points={{-79,110},{-72,110},
            {-72,-10},{-62,-10}},color={0,0,127}));
    connect(ramp.y, secondOrder.u) annotation (Line(points={{-79,110},{-72,110},
            {-72,-50},{-62,-50}},color={0,0,127}));
    connect(ramp.y, pI.u) annotation (Line(points={{-79,110},{-72,110},{-72,-90},
            {-62,-90}}, color={0,0,127}));
    connect(ramp.y, pID.u) annotation (Line(points={{-79,110},{-72,110},{-72,-130},
            {-62,-130}}, color={0,0,127}));
    connect(ramp1.y, limPID.u_s)
      annotation (Line(points={{21,110},{38,110}}, color={0,0,127}));
    connect(ramp1.y, transferFunction.u) annotation (Line(points={{21,110},{28,
            110},{28,30},{38,30}}, color={0,0,127}));
    connect(ramp1.y, stateSpace.u[1]) annotation (Line(points={{21,110},{28,110},
            {28,-10},{38,-10}}, color={0,0,127}));
    connect(ramp1.y, lowpassButterworth.u) annotation (Line(points={{21,110},{
            28,110},{28,-50},{38,-50}}, color={0,0,127}));
    connect(ramp1.y, criticalDamping.u) annotation (Line(points={{21,110},{28,
            110},{28,-90},{38,-90}}, color={0,0,127}));
    connect(const.y, limPID.u_m)
      annotation (Line(points={{50,81},{50,98}}, color={0,0,127}));
    connect(sine.y, der1.u) annotation (Line(
        points={{21,-130},{38,-130}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=1.1), Diagram(coordinateSystem(
            preserveAspectRatio=true, extent={{-100,-140},{100,140}})));
  end Continuous;

  model Continuous_SteadyState
    extends ModelicaTest.Blocks.Continuous(
      derivative(initType=Modelica.Blocks.Types.Init.SteadyState),
      firstOrder(initType=Modelica.Blocks.Types.Init.SteadyState),
      secondOrder(initType=Modelica.Blocks.Types.Init.SteadyState),
      transferFunction(
        initType=Modelica.Blocks.Types.Init.SteadyState,
        a={1,1},
        b={1}),
      stateSpace(
        initType=Modelica.Blocks.Types.Init.SteadyState,
        A=[1, 0; 0, 1],
        B=[1; 1],
        C=[1, 1]),
      lowpassButterworth(initType=Modelica.Blocks.Types.Init.SteadyState),
      criticalDamping(initType=Modelica.Blocks.Types.Init.SteadyState,
          normalized=false));
    annotation (experiment(StopTime=1.1));
  end Continuous_SteadyState;

  model Continuous_InitialState
    extends ModelicaTest.Blocks.Continuous(
      integrator(initType=Modelica.Blocks.Types.Init.InitialState),
      limIntegrator(initType=Modelica.Blocks.Types.Init.InitialState),
      derivative(initType=Modelica.Blocks.Types.Init.InitialState),
      firstOrder(initType=Modelica.Blocks.Types.Init.InitialState),
      secondOrder(initType=Modelica.Blocks.Types.Init.InitialState),
      pI(initType=Modelica.Blocks.Types.Init.InitialState),
      pID(initType=Modelica.Blocks.Types.InitPID.InitialState),
      limPID(initType=Modelica.Blocks.Types.InitPID.InitialState),
      transferFunction(
        initType=Modelica.Blocks.Types.Init.InitialState,
        a={1,1},
        b={1}),
      stateSpace(
        initType=Modelica.Blocks.Types.Init.InitialState,
        A=[1, 0; 0, 1],
        B=[1; 1],
        C=[1, 1]),
      lowpassButterworth(initType=Modelica.Blocks.Types.Init.InitialState),
      criticalDamping(initType=Modelica.Blocks.Types.Init.InitialState,
          normalized=false));
    annotation (experiment(StopTime=1.1));
  end Continuous_InitialState;

  model Continuous_InitialOutput
    extends ModelicaTest.Blocks.Continuous(
      integrator(initType=Modelica.Blocks.Types.Init.InitialOutput, y_start=2),
      limIntegrator(initType=Modelica.Blocks.Types.Init.InitialOutput, y_start=
            0.5),
      derivative(initType=Modelica.Blocks.Types.Init.InitialOutput, y_start=2),
      firstOrder(initType=Modelica.Blocks.Types.Init.InitialOutput, y_start=2),
      secondOrder(initType=Modelica.Blocks.Types.Init.InitialOutput, y_start=2),
      pI(initType=Modelica.Blocks.Types.Init.InitialOutput, y_start=2),
      pID(initType=Modelica.Blocks.Types.InitPID.InitialOutput, y_start=2),
      limPID(
        initType=Modelica.Blocks.Types.InitPID.InitialOutput,
        yMax=3,
        y_start=2),
      transferFunction(
        initType=Modelica.Blocks.Types.Init.InitialOutput,
        y_start=2,
        a={1,1},
        b={1}),
      stateSpace(
        initType=Modelica.Blocks.Types.Init.InitialOutput,
        y_start={2},
        A=[1, 0; 0, 1],
        B=[1; 1],
        C=[1, 1]),
      lowpassButterworth(initType=Modelica.Blocks.Types.Init.InitialOutput,
          y_start=2),
      criticalDamping(
        initType=Modelica.Blocks.Types.Init.InitialOutput,
        y_start=2,
        normalized=false));

    annotation (experiment(StopTime=1.1));
  end Continuous_InitialOutput;

  model Limiters
    extends Modelica.Icons.Example;
    Modelica.Blocks.Nonlinear.Limiter limiter(limitsAtInit=false, uMax=1)
      annotation (Placement(transformation(extent={{0,0},{20,20}}, rotation=0)));
    Modelica.Blocks.Nonlinear.VariableLimiter variableLimiter(limitsAtInit=
          false) annotation (Placement(transformation(extent={{0,-40},{20,-20}},
            rotation=0)));
    Modelica.Blocks.Nonlinear.DeadZone deadZone(deadZoneAtInit=false, uMax=1)
      annotation (Placement(transformation(extent={{0,-80},{20,-60}}, rotation=
              0)));
    Modelica.Blocks.Sources.Sine sine(amplitude=2, freqHz=1) annotation (
        Placement(transformation(extent={{-80,20},{-60,40}}, rotation=0)));
    Modelica.Blocks.Sources.Constant constPos(k=+1) annotation (Placement(
          transformation(extent={{-80,-20},{-60,0}}, rotation=0)));
    Modelica.Blocks.Sources.Constant constNeg(k=-1) annotation (Placement(
          transformation(extent={{-80,-60},{-60,-40}}, rotation=0)));
    Modelica.Blocks.Nonlinear.SlewRateLimiter slewRateLimiter(Rising=10)
      annotation (Placement(transformation(extent={{0,40},{20,60}})));
    Modelica.Blocks.Continuous.Der idealDerivative
      annotation (Placement(transformation(extent={{40,40},{60,60}})));
  equation
    assert(idealDerivative.y <= slewRateLimiter.Rising and idealDerivative.y
       >= slewRateLimiter.Falling,
      "Test of Modelica.Blocks.Nonlinear.SlewRateLimiter failed!");
    assert(limiter.y <= limiter.uMax and limiter.y >= limiter.uMin,
      "Test of Modelica.Blocks.Nonlinear.Limiter failed!");
    assert(variableLimiter.y <= constPos.y and variableLimiter.y >= constNeg.y,
      "Test of Modelica.Blocks.Nonlinear.VariableLimiter failed!");
    connect(sine.y, limiter.u) annotation (Line(points={{-59,30},{-20,30},{-20,
            10},{-2,10}}, color={0,0,127}));
    connect(constPos.y, variableLimiter.limit1) annotation (Line(points={{-59,-10},
            {-40,-10},{-40,-22},{-2,-22}}, color={0,0,127}));
    connect(constNeg.y, variableLimiter.limit2) annotation (Line(points={{-59,-50},
            {-40,-50},{-40,-38},{-2,-38}}, color={0,0,127}));
    connect(sine.y, variableLimiter.u) annotation (Line(points={{-59,30},{-20,
            30},{-20,-30},{-2,-30}},color={0,0,127}));
    connect(sine.y, deadZone.u) annotation (Line(points={{-59,30},{-20,30},{-20,
            -70},{-2,-70}}, color={0,0,127}));
    connect(sine.y, slewRateLimiter.u) annotation (Line(
        points={{-59,30},{-20,30},{-20,50},{-2,50}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(slewRateLimiter.y, idealDerivative.u) annotation (Line(
        points={{21,50},{38,50}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=1.1));
  end Limiters;

  model StrictLimiters
    extends Modelica.Icons.Example;
    Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=1.1)
      annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
    Modelica.Blocks.Sources.Sine sine1(amplitude=1.5, freqHz=2)
      annotation (Placement(transformation(extent={{-80,60},{-60,80}})));
    Modelica.Blocks.Nonlinear.Limiter limiter2(uMax=1.1, strict=true)
      annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
    Modelica.Blocks.Nonlinear.VariableLimiter variableLimiter1
      annotation (Placement(transformation(extent={{-20,-40},{0,-20}})));
    Modelica.Blocks.Sources.Sine sine2(amplitude=1.5, freqHz=2)
      annotation (Placement(transformation(extent={{-80,-40},{-60,-20}})));
    Modelica.Blocks.Sources.Sine sine2a(
      amplitude=0.3,
      freqHz=4,
      offset=1.0)
      annotation (Placement(transformation(extent={{-80,-8},{-60,12}})));
    Modelica.Blocks.Sources.Sine sine2ab(
      amplitude=0.3,
      freqHz=4,
      offset=-1.0)
      annotation (Placement(transformation(extent={{-80,-80},{-60,-60}})));
    Modelica.Blocks.Nonlinear.VariableLimiter variableLimiter2(strict=true)
      annotation (Placement(transformation(extent={{-20,-80},{0,-60}})));
    Modelica.Blocks.Nonlinear.SlewRateLimiter slewRateLimiter1(Rising=13)
      annotation (Placement(transformation(extent={{40,60},{60,80}})));
    Modelica.Blocks.Sources.Sine sine3(amplitude=1.5, freqHz=2)
      annotation (Placement(transformation(extent={{0,60},{20,80}})));
    Modelica.Blocks.Continuous.Der der1
      annotation (Placement(transformation(extent={{72,60},{92,80}})));
    Modelica.Blocks.Nonlinear.SlewRateLimiter slewRateLimiter2(strict=true,
        Rising=13)
      annotation (Placement(transformation(extent={{40,30},{60,50}})));
    Modelica.Blocks.Continuous.Der der2
      annotation (Placement(transformation(extent={{72,30},{92,50}})));
    Modelica.Blocks.Continuous.LimIntegrator limIntegrator1(k=5.0, outMax=0.9)
      annotation (Placement(transformation(extent={{40,0},{60,20}})));
    Modelica.Blocks.Continuous.LimIntegrator limIntegrator2(
      strict=true,
      k=5.0,
      outMax=0.9)
      annotation (Placement(transformation(extent={{40,-30},{60,-10}})));
    Modelica.Blocks.Continuous.LimPID PID1(yMax=0.4, initType=Modelica.Blocks.Types.InitPID.InitialOutput)
      annotation (Placement(transformation(extent={{38,-60},{58,-40}})));
    Modelica.Blocks.Continuous.LimPID PID2(
      yMax=0.4,
      strict=true,
      initType=Modelica.Blocks.Types.InitPID.InitialOutput)
      annotation (Placement(transformation(extent={{40,-100},{60,-80}})));
  equation
    connect(sine1.y, limiter1.u) annotation (Line(
        points={{-59,70},{-42,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine1.y, limiter2.u) annotation (Line(
        points={{-59,70},{-52,70},{-52,30},{-42,30}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine2.y, variableLimiter1.u) annotation (Line(
        points={{-59,-30},{-22,-30}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine2a.y, variableLimiter1.limit1) annotation (Line(
        points={{-59,2},{-50,2},{-50,-22},{-22,-22}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine2ab.y, variableLimiter1.limit2) annotation (Line(
        points={{-59,-70},{-52,-70},{-52,-38},{-22,-38}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(variableLimiter2.limit1, variableLimiter1.limit1) annotation (Line(
        points={{-22,-62},{-34,-62},{-34,-22},{-22,-22}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(variableLimiter2.limit2, variableLimiter1.limit2) annotation (Line(
        points={{-22,-78},{-46,-78},{-46,-38},{-22,-38}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(variableLimiter2.u, variableLimiter1.u) annotation (Line(
        points={{-22,-70},{-40,-70},{-40,-30},{-22,-30}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine3.y, slewRateLimiter1.u) annotation (Line(
        points={{21,70},{38,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(slewRateLimiter1.y, der1.u) annotation (Line(
        points={{61,70},{70,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine3.y, slewRateLimiter2.u) annotation (Line(
        points={{21,70},{28,70},{28,40},{38,40}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(slewRateLimiter2.y, der2.u) annotation (Line(
        points={{61,40},{70,40}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine3.y, limIntegrator1.u) annotation (Line(
        points={{21,70},{28,70},{28,10},{38,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(limIntegrator2.u, limIntegrator1.u) annotation (Line(
        points={{38,-20},{28,-20},{28,10},{38,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(PID1.u_s, limIntegrator1.u) annotation (Line(
        points={{36,-50},{28,-50},{28,10},{38,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(variableLimiter2.y, PID1.u_m) annotation (Line(
        points={{1,-70},{48,-70},{48,-62}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(PID2.u_s, limIntegrator1.u) annotation (Line(
        points={{38,-90},{28,-90},{28,10},{38,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(PID2.u_m, PID1.u_m) annotation (Line(
        points={{50,-102},{50,-110},{16,-110},{16,-70},{48,-70},{48,-62}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=1.1));
  end StrictLimiters;

  model KinematicPTP
    extends Modelica.Icons.Example;
    Modelica.Blocks.Sources.KinematicPTP kinematicPTP1a(
      qd_max={3},
      qdd_max={4},
      startTime=0.5,
      deltaq={1}) annotation (Placement(transformation(extent={{-60,60},{-40,80}},
            rotation=0)));
    Modelica.Blocks.Continuous.Integrator integrator annotation (Placement(
          transformation(extent={{-20,60},{2,80}}, rotation=0)));
    Modelica.Blocks.Continuous.Integrator integrator1(y_start=1) annotation (
        Placement(transformation(extent={{20,60},{42,80}}, rotation=0)));
    Modelica.Blocks.Sources.KinematicPTP kinematicPTP2a(
      qd_max={3},
      qdd_max={4},
      startTime=0.5,
      deltaq={4}) annotation (Placement(transformation(extent={{-60,-20},{-40,0}},
            rotation=0)));
    Modelica.Blocks.Continuous.Integrator integrator2 annotation (Placement(
          transformation(extent={{-20,-20},{2,0}}, rotation=0)));
    Modelica.Blocks.Continuous.Integrator integrator3(y_start=1) annotation (
        Placement(transformation(extent={{20,-20},{42,0}}, rotation=0)));
    Modelica.Blocks.Sources.KinematicPTP2 kinematicPTP1b(
      qd_max={3},
      qdd_max={4},
      startTime=0.5,
      q_end={2},
      q_begin={1})
      annotation (Placement(transformation(extent={{-60,22},{-40,42}})));
    Modelica.Blocks.Sources.KinematicPTP2 kinematicPTP2b(
      qd_max={3},
      qdd_max={4},
      startTime=0.5,
      q_end={5},
      q_begin={1})
      annotation (Placement(transformation(extent={{-60,-58},{-40,-38}})));
    Modelica.Blocks.Math.Feedback diff1
      annotation (Placement(transformation(extent={{56,60},{76,80}})));
    Modelica.Blocks.Math.Feedback diff2
      annotation (Placement(transformation(extent={{60,-20},{80,0}})));
  equation
    connect(kinematicPTP1a.y[1], integrator.u)
      annotation (Line(points={{-39,70},{-22.2,70}}, color={0,0,127}));
    connect(integrator.y, integrator1.u)
      annotation (Line(points={{3.1,70},{17.8,70}}, color={0,0,127}));
    connect(kinematicPTP2a.y[1], integrator2.u)
      annotation (Line(points={{-39,-10},{-22.2,-10}}, color={0,0,127}));
    connect(integrator2.y, integrator3.u)
      annotation (Line(points={{3.1,-10},{17.8,-10}}, color={0,0,127}));
    connect(integrator1.y, diff1.u1) annotation (Line(
        points={{43.1,70},{58,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(kinematicPTP1b.q[1], diff1.u2) annotation (Line(
        points={{-39,40},{66,40},{66,62}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(integrator3.y, diff2.u1) annotation (Line(
        points={{43.1,-10},{62,-10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(kinematicPTP2b.q[1], diff2.u2) annotation (Line(
        points={{-39,-40},{70,-40},{70,-18}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=3));
  end KinematicPTP;

  model UnitDeduction "Test unit deduction"
    extends Modelica.Icons.Example;
    Modelica.Blocks.Continuous.Integrator integrator
      annotation (Placement(transformation(extent={{0,30},{20,50}})));
    Modelica.Mechanics.Rotational.Components.Inertia inertia(
      J=1,
      w(start=1, fixed=true),
      phi(fixed=true, start=0))
      annotation (Placement(transformation(extent={{-80,60},{-60,80}})));
    Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor
      annotation (Placement(transformation(extent={{-50,60},{-30,80}})));
    Modelica.Blocks.Math.Gain gain(k=2)
      annotation (Placement(transformation(extent={{0,80},{20,100}})));
    Modelica.Blocks.Continuous.LimIntegrator limIntegrator(outMax=3)
      annotation (Placement(transformation(extent={{0,0},{20,20}})));
    Modelica.Blocks.Continuous.Derivative derivative(initType=Modelica.Blocks.Types.Init.InitialState)
      annotation (Placement(transformation(extent={{0,-30},{20,-10}})));
    Modelica.Blocks.Continuous.FirstOrder firstOrder(T=2, initType=Modelica.Blocks.Types.Init.InitialState)
      annotation (Placement(transformation(extent={{0,-60},{20,-40}})));
    Modelica.Blocks.Continuous.SecondOrder secondOrder(
      w=2,
      D=3,
      initType=Modelica.Blocks.Types.Init.InitialState)
      annotation (Placement(transformation(extent={{0,-90},{20,-70}})));
    Modelica.Blocks.Continuous.PI PI(T=2, initType=Modelica.Blocks.Types.Init.InitialState)
      annotation (Placement(transformation(extent={{60,60},{80,80}})));
    Modelica.Blocks.Continuous.PID PID(
      Ti=2,
      Td=3,
      initType=Modelica.Blocks.Types.InitPID.InitialState)
      annotation (Placement(transformation(extent={{60,30},{80,50}})));
    Modelica.Blocks.Continuous.LimPID PID1(
      Ti=2,
      Td=3,
      yMax=4,
      initType=Modelica.Blocks.Types.InitPID.InitialState)
      annotation (Placement(transformation(extent={{60,0},{80,20}})));
    Modelica.Electrical.Analog.Sources.SineVoltage sineVoltage(V=10, freqHz=2)
      annotation (Placement(transformation(
          extent={{-10,-10},{10,10}},
          rotation=270,
          origin={120,-20})));
    Modelica.Electrical.Analog.Basic.Resistor resistor(R=100) annotation (
        Placement(transformation(
          extent={{-10,-10},{10,10}},
          rotation=270,
          origin={168,-20})));
    Modelica.Electrical.Analog.Basic.Ground ground
      annotation (Placement(transformation(extent={{110,-70},{130,-50}})));
    Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor annotation (
        Placement(transformation(
          extent={{-10,10},{10,-10}},
          rotation=270,
          origin={190,-20})));
    Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor
      annotation (Placement(transformation(extent={{138,10},{158,-10}})));
    Modelica.Blocks.Math.Product product
      annotation (Placement(transformation(extent={{225,15},{235,25}})));
    Modelica.Blocks.Continuous.Integrator Wsec(k(unit="1"))
      annotation (Placement(transformation(extent={{249,15},{259,25}})));
    Modelica.Blocks.Continuous.Integrator Vsec(k(unit="1"))
      annotation (Placement(transformation(extent={{246,-26},{258,-14}})));
    Modelica.Blocks.Continuous.Integrator Asec(k(unit="1")) annotation (
        Placement(transformation(extent={{183.5,43.5},{196.5,56.5}})));
  equation
    connect(inertia.flange_b, speedSensor.flange) annotation (Line(
        points={{-60,70},{-50,70}},
        color={0,0,0},
        smooth=Smooth.None));
    connect(speedSensor.w, integrator.u) annotation (Line(
        points={{-29,70},{-16,70},{-16,40},{-2,40}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(speedSensor.w, gain.u) annotation (Line(
        points={{-29,70},{-16,70},{-16,90},{-2,90}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(speedSensor.w, limIntegrator.u) annotation (Line(
        points={{-29,70},{-16,70},{-16,10},{-2,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(derivative.u, speedSensor.w) annotation (Line(
        points={{-2,-20},{-16,-20},{-16,70},{-29,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(firstOrder.u, speedSensor.w) annotation (Line(
        points={{-2,-50},{-16,-50},{-16,70},{-29,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(secondOrder.u, speedSensor.w) annotation (Line(
        points={{-2,-80},{-16,-80},{-16,70},{-29,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(speedSensor.w, PI.u) annotation (Line(
        points={{-29,70},{58,70}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(speedSensor.w, PID.u) annotation (Line(
        points={{-29,70},{40,70},{40,40},{58,40}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(speedSensor.w, PID1.u_s) annotation (Line(
        points={{-29,70},{40,70},{40,10},{58,10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(gain.y, PID1.u_m) annotation (Line(
        points={{21,90},{94,90},{94,-8},{70,-8},{70,-2}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sineVoltage.n, ground.p) annotation (Line(
        points={{120,-30},{120,-50}},
        color={0,0,255},
        smooth=Smooth.None));
    connect(sineVoltage.p, currentSensor.p) annotation (Line(
        points={{120,-10},{120,0},{138,0}},
        color={0,0,255},
        smooth=Smooth.None));
    connect(voltageSensor.p, resistor.p) annotation (Line(
        points={{190,-10},{190,0},{168,0},{168,-10}},
        color={0,0,255},
        smooth=Smooth.None));
    connect(resistor.p, currentSensor.n) annotation (Line(
        points={{168,-10},{168,0},{158,0}},
        color={0,0,255},
        smooth=Smooth.None));
    connect(voltageSensor.n, resistor.n) annotation (Line(
        points={{190,-30},{190,-40},{168,-40},{168,-30}},
        color={0,0,255},
        smooth=Smooth.None));
    connect(resistor.n, sineVoltage.n) annotation (Line(
        points={{168,-30},{168,-40},{120,-40},{120,-30}},
        color={0,0,255},
        smooth=Smooth.None));
    connect(currentSensor.i, product.u1) annotation (Line(
        points={{148,10},{172,10},{172,23},{224,23}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(voltageSensor.v, product.u2) annotation (Line(
        points={{200,-20},{210.5,-20},{210.5,17},{224,17}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(currentSensor.i, Asec.u) annotation (Line(
        points={{148,10},{172,10},{172,50},{182.2,50}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(product.y, Wsec.u) annotation (Line(
        points={{235.5,20},{248,20}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(Vsec.u, voltageSensor.v) annotation (Line(
        points={{244.8,-20},{222.4,-20},{222.4,-20},{200,-20}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=1.01));
  end UnitDeduction;

  model Logical
    extends Modelica.Icons.Example;
    Modelica.Blocks.Sources.BooleanTable
                         table1(table={2,4,6,8}) annotation (Placement(
          transformation(extent={{-100,100},{-80,120}},
                                                     rotation=0)));
    Modelica.Blocks.Sources.BooleanTable
                         table2(table={1,3,5,7}) annotation (Placement(
          transformation(extent={{-100,60},{-80,80}},rotation=0)));
    Modelica.Blocks.Logical.And and1
      annotation (Placement(transformation(extent={{-60,100},{-40,120}})));
    Modelica.Blocks.Logical.Or or1
      annotation (Placement(transformation(extent={{-20,100},{0,120}})));
    Modelica.Blocks.Logical.Xor xor
      annotation (Placement(transformation(extent={{-20,140},{0,160}})));
    Modelica.Blocks.Logical.Nor nor
      annotation (Placement(transformation(extent={{20,140},{40,160}})));
    Modelica.Blocks.Logical.Nand nand
      annotation (Placement(transformation(extent={{60,140},{80,160}})));
    Modelica.Blocks.Logical.Not not1
      annotation (Placement(transformation(extent={{20,100},{40,120}})));
    Modelica.Blocks.Logical.Pre pre1
      annotation (Placement(transformation(extent={{60,100},{80,120}})));
    Modelica.Blocks.Logical.Edge edge1
      annotation (Placement(transformation(extent={{20,0},{40,20}})));
    Modelica.Blocks.Logical.FallingEdge fallingEdge
      annotation (Placement(transformation(extent={{20,-40},{40,-20}})));
    Modelica.Blocks.Logical.Change change1
      annotation (Placement(transformation(extent={{20,-80},{40,-60}})));
    Modelica.Blocks.Logical.GreaterThreshold greaterThreshold(threshold=0.1)
      annotation (Placement(transformation(extent={{-60,-20},{-40,0}})));
    Modelica.Blocks.Sources.Sine sine(amplitude=2, freqHz=0.5)
      annotation (Placement(transformation(extent={{-100,-20},{-80,0}})));
    Modelica.Blocks.Logical.GreaterEqualThreshold greaterEqualThreshold(
        threshold=-0.1)
      annotation (Placement(transformation(extent={{-60,-48},{-40,-28}})));
    Modelica.Blocks.Logical.LessThreshold lessThreshold(threshold=0.1)
      annotation (Placement(transformation(extent={{-60,-76},{-40,-56}})));
    Modelica.Blocks.Logical.LessEqualThreshold lessEqualThreshold(threshold=-0.1)
      annotation (Placement(transformation(extent={{-60,-104},{-40,-84}})));
    Modelica.Blocks.Logical.Greater greater
      annotation (Placement(transformation(extent={{-60,-140},{-40,-120}})));
    Modelica.Blocks.Sources.Ramp ramp(height=5, duration=8)
      annotation (Placement(transformation(extent={{-102,-148},{-82,-128}})));
    Modelica.Blocks.Logical.GreaterEqual greaterEqual
      annotation (Placement(transformation(extent={{-20,-140},{0,-120}})));
    Modelica.Blocks.Logical.Less less
      annotation (Placement(transformation(extent={{20,-140},{40,-120}})));
    Modelica.Blocks.Logical.LessEqual lessEqual
      annotation (Placement(transformation(extent={{60,-140},{80,-120}})));
    Modelica.Blocks.Logical.ZeroCrossing zeroCrossing
      annotation (Placement(transformation(extent={{-60,12},{-40,32}})));
    Modelica.Blocks.Logical.LogicalSwitch logicalSwitch
      annotation (Placement(transformation(extent={{100,120},{120,140}})));
    Modelica.Blocks.Logical.Switch switch1
      annotation (Placement(transformation(extent={{80,-80},{100,-60}})));
    Modelica.Blocks.Logical.Hysteresis hysteresis(uLow=-0.5, uHigh=0.5)
      annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
    Modelica.Blocks.Logical.OnOffController onOffController(bandwidth=0.5)
      annotation (Placement(transformation(extent={{80,-40},{100,-20}})));
    Modelica.Blocks.Logical.TriggeredTrapezoid triggeredTrapezoid(rising=1,
        falling=0.5)
      annotation (Placement(transformation(extent={{106,60},{126,80}})));
    Modelica.Blocks.Logical.Timer timer
      annotation (Placement(transformation(extent={{100,20},{120,40}})));
    Modelica.Blocks.Logical.RSFlipFlop rSFlipFlop
      annotation (Placement(transformation(extent={{140,120},{160,140}})));
  equation
    connect(table1.y, and1.u1) annotation (Line(
        points={{-79,110},{-62,110}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(table2.y, and1.u2) annotation (Line(
        points={{-79,70},{-72,70},{-72,102},{-62,102}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(and1.y, or1.u1) annotation (Line(
        points={{-39,110},{-22,110}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(table2.y, or1.u2) annotation (Line(
        points={{-79,70},{-34,70},{-34,102},{-22,102}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(table1.y, xor.u1) annotation (Line(
        points={{-79,110},{-72,110},{-72,150},{-22,150}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(and1.y, xor.u2) annotation (Line(
        points={{-39,110},{-32,110},{-32,142},{-22,142}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(xor.y, nor.u1) annotation (Line(
        points={{1,150},{18,150}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(or1.y, nor.u2) annotation (Line(
        points={{1,110},{10,110},{10,142},{18,142}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(nor.y, nand.u1) annotation (Line(
        points={{41,150},{58,150}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(table2.y, nand.u2) annotation (Line(
        points={{-79,70},{46,70},{46,142},{58,142}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(or1.y, not1.u) annotation (Line(
        points={{1,110},{18,110}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(not1.y, pre1.u) annotation (Line(
        points={{41,110},{58,110}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(or1.y, edge1.u) annotation (Line(
        points={{1,110},{10,110},{10,10},{18,10}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(or1.y, fallingEdge.u) annotation (Line(
        points={{1,110},{10,110},{10,-30},{18,-30}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(or1.y, change1.u) annotation (Line(
        points={{1,110},{10,110},{10,-70},{18,-70}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(sine.y, greaterThreshold.u) annotation (Line(
        points={{-79,-10},{-62,-10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine.y, greaterEqualThreshold.u) annotation (Line(
        points={{-79,-10},{-72,-10},{-72,-38},{-62,-38}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine.y, lessThreshold.u) annotation (Line(
        points={{-79,-10},{-72,-10},{-72,-66},{-62,-66}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine.y, lessEqualThreshold.u) annotation (Line(
        points={{-79,-10},{-72,-10},{-72,-94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(ramp.y, greater.u2) annotation (Line(
        points={{-81,-138},{-62,-138}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(ramp.y, greaterEqual.u2) annotation (Line(
        points={{-81,-138},{-74,-138},{-74,-154},{-32,-154},{-32,-138},{-22,
            -138}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(less.u2, greaterEqual.u2) annotation (Line(
        points={{18,-138},{10,-138},{10,-154},{-32,-154},{-32,-138},{-22,-138}},
        color={0,0,127},
        smooth=Smooth.None));

    connect(lessEqual.u2, greaterEqual.u2) annotation (Line(
        points={{58,-138},{50,-138},{50,-154},{-32,-154},{-32,-138},{-22,-138}},
        color={0,0,127},
        smooth=Smooth.None));

    connect(greater.u1, lessEqualThreshold.u) annotation (Line(
        points={{-62,-130},{-72,-130},{-72,-94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(greaterEqual.u1, lessEqualThreshold.u) annotation (Line(
        points={{-22,-130},{-30,-130},{-30,-112},{-72,-112},{-72,-94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));

    connect(less.u1, lessEqualThreshold.u) annotation (Line(
        points={{18,-130},{12,-130},{12,-112},{-72,-112},{-72,-94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(lessEqual.u1, lessEqualThreshold.u) annotation (Line(
        points={{58,-130},{52,-130},{52,-112},{-72,-112},{-72,-94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(zeroCrossing.u, greaterThreshold.u) annotation (Line(
        points={{-62,22},{-72,22},{-72,-10},{-62,-10}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(greaterThreshold.y, zeroCrossing.enable) annotation (Line(
        points={{-39,-10},{-22,-10},{-22,4},{-50,4},{-50,10}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(nand.y, logicalSwitch.u1) annotation (Line(
        points={{81,150},{90,150},{90,138},{98,138}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(pre1.y, logicalSwitch.u2) annotation (Line(
        points={{81,110},{88,110},{88,130},{98,130}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(table2.y, logicalSwitch.u3) annotation (Line(
        points={{-79,70},{92,70},{92,122},{98,122}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(change1.y, switch1.u2) annotation (Line(
        points={{41,-70},{78,-70}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(switch1.u1, lessEqualThreshold.u) annotation (Line(
        points={{78,-62},{52,-62},{52,-112},{-72,-112},{-72,-94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(switch1.u3, greaterEqual.u2) annotation (Line(
        points={{78,-78},{66,-78},{66,-106},{106,-106},{106,-154},{-32,-154},{
            -32,-138},{-22,-138}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine.y, hysteresis.u) annotation (Line(
        points={{-79,-10},{-72,-10},{-72,50},{-62,50}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(onOffController.reference, lessEqualThreshold.u) annotation (Line(
        points={{78,-24},{66,-24},{66,-24},{52,-24},{52,-112},{-72,-112},{-72,
            -94},{-62,-94}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(onOffController.u, greaterEqual.u2) annotation (Line(
        points={{78,-36},{66,-36},{66,-106},{106,-106},{106,-154},{-32,-154},{
            -32,-138},{-22,-138}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(table2.y, triggeredTrapezoid.u) annotation (Line(
        points={{-79,70},{104,70}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(timer.u, logicalSwitch.u3) annotation (Line(
        points={{98,30},{94,30},{94,30},{92,30},{92,122},{98,122}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(nand.y, rSFlipFlop.S) annotation (Line(
        points={{81,150},{128,150},{128,136},{138,136}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(pre1.y, rSFlipFlop.R) annotation (Line(
        points={{81,110},{130,110},{130,124},{138,124}},
        color={255,0,255},
        smooth=Smooth.None));
    annotation (experiment(StopTime=10), Diagram(coordinateSystem(
            preserveAspectRatio=false,extent={{-100,-180},{180,180}})));
  end Logical;

  model IntegerTable
    extends Modelica.Icons.Example;
    Modelica.Blocks.Sources.IntegerTable integerTable(table=[0, 1; 1, 4; 1.5, 5;
          2, 6])
      annotation (Placement(transformation(extent={{-80,60},{-60,80}})));
    Modelica.Blocks.Sources.IntegerTable integerTable2(table=[0, -1])
      annotation (Placement(transformation(extent={{-80,20},{-60,40}})));
    Modelica.Blocks.Sources.IntegerTable integerTable3(table=[2, -2])
      annotation (Placement(transformation(extent={{-80,-20},{-60,0}})));
    Modelica.Blocks.Sources.IntegerTable integerTable4(table=[0, 1; 1, 4; 1.5,
          5; 2, 6; 4, 7])
      annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
    annotation (experiment(StopTime=3));
  end IntegerTable;

  model BooleanTable
    extends Modelica.Icons.Example;
    Modelica.Blocks.Sources.BooleanTable booleanTable1(table={1,1.5,2})
      annotation (Placement(transformation(extent={{-80,60},{-60,80}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable2a(table={0,1,2})
      annotation (Placement(transformation(extent={{-80,20},{-60,40}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable2b(table={-1,0,1,2})
      annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable3a(table={1})
      annotation (Placement(transformation(extent={{-80,-20},{-60,0}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable3b(table={0})
      annotation (Placement(transformation(extent={{-40,-20},{-20,0}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable3c(table={-1})
      annotation (Placement(transformation(extent={{0,-20},{20,0}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable4a(table=fill(0.0, 0))
      annotation (Placement(transformation(extent={{-80,-60},{-60,-40}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable4b(table=fill(0.0, 0),
        startValue=true)
      annotation (Placement(transformation(extent={{-40,-60},{-20,-40}})));
    annotation (experiment(StopTime=3), Diagram(coordinateSystem(
            preserveAspectRatio=false, extent={{-100,-100},{100,100}}), graphics));
  end BooleanTable;

  model RootMeanSquare
    extends Modelica.Icons.Example;
    Modelica.Blocks.Math.Mean mean1(f=expSine.freqHz)
      annotation (Placement(transformation(extent={{-40,40},{-20,60}})));
    Modelica.Blocks.Sources.ExpSine expSine(
      freqHz=2,
      damping=0.5,
      offset=-0.5)
      annotation (Placement(transformation(extent={{-80,40},{-60,60}})));
    Modelica.Blocks.Math.RootMeanSquare rootMeanSquare(f=expSine.freqHz)
      annotation (Placement(transformation(extent={{-40,0},{-20,20}})));
  equation
    connect(expSine.y, mean1.u) annotation (Line(
        points={{-59,50},{-42,50}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(expSine.y, rootMeanSquare.u) annotation (Line(
        points={{-59,50},{-52,50},{-52,10},{-42,10}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=2));
  end RootMeanSquare;

  model FirstOrderHold "Test first order hold of Discrete package"
    extends Modelica.Icons.Example;
    parameter Real period=0.05;
    Modelica.Blocks.Sources.Sine sine(freqHz=1, offset=0.5)
      annotation (Placement(transformation(extent={{-80,0},{-60,20}})));
    Modelica.Blocks.Discrete.ZeroOrderHold zeroOrderHold(samplePeriod=period)
      annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
    Modelica.Blocks.Discrete.FirstOrderHold firstOrderHold(samplePeriod=period)
      annotation (Placement(transformation(extent={{-40,-20},{-20,0}})));
  equation
    connect(sine.y, zeroOrderHold.u) annotation (Line(
        points={{-59,10},{-50,10},{-50,30},{-42,30}},
        color={0,0,127},
        smooth=Smooth.None));
    connect(sine.y, firstOrderHold.u) annotation (Line(
        points={{-59,10},{-50,10},{-50,-10},{-42,-10}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=2));
  end FirstOrderHold;

  model OnDelay
    extends Modelica.Icons.Example;
    Modelica.Blocks.MathBoolean.OnDelay onDelay1(delayTime=1)
      annotation (Placement(transformation(extent={{-14,66},{-6,74}})));
    Modelica.Blocks.Sources.BooleanTable booleanTable(table={1,4,6,8,9,9.5})
      annotation (Placement(transformation(extent={{-60,60},{-40,80}})));
    Modelica.Blocks.Sources.BooleanStep booleanStep3(startValue=true, startTime=
         2) annotation (Placement(transformation(extent={{-60,-20},{-40,0}})));
    Modelica.Blocks.MathBoolean.OnDelay onDelay3(delayTime=1)
      annotation (Placement(transformation(extent={{-14,-14},{-6,-6}})));
    Modelica.Blocks.Sources.BooleanStep booleanStep2(startTime=2, startValue=
          false)
      annotation (Placement(transformation(extent={{-60,20},{-40,40}})));
    Modelica.Blocks.MathBoolean.OnDelay onDelay2(delayTime=1)
      annotation (Placement(transformation(extent={{-14,26},{-6,34}})));
  equation
    connect(booleanTable.y, onDelay1.u) annotation (Line(
        points={{-39,70},{-15.6,70}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(booleanStep3.y, onDelay3.u) annotation (Line(
        points={{-39,-10},{-15.6,-10}},
        color={255,0,255},
        smooth=Smooth.None));
    connect(booleanStep2.y, onDelay2.u) annotation (Line(
        points={{-39,30},{-15.6,30}},
        color={255,0,255},
        smooth=Smooth.None));
    annotation (experiment(StopTime=11), Diagram(coordinateSystem(
            preserveAspectRatio=false, extent={{-100,-140},{100,140}})));
  end OnDelay;

  model Mean
    extends Modelica.Icons.Example;
    Modelica.Blocks.Math.Mean mean(f=2)
      annotation (Placement(transformation(extent={{-20,40},{0,60}})));
    Modelica.Blocks.Sources.Sine sine(offset=0.5, freqHz=2)
      annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
  equation
    connect(sine.y, mean.u) annotation (Line(
        points={{-39,50},{-22,50}},
        color={0,0,127},
        smooth=Smooth.None));
    annotation (experiment(StopTime=1.1), Diagram(coordinateSystem(
            preserveAspectRatio=false, extent={{-100,-140},{100,140}})));
  end Mean;

  package FilterTests "Test of Blocks.Continuous.Filter"
    extends Modelica.Icons.ExamplesPackage;
    model AllOptions
      "Simulates 264 filter blocks and varies all possible options systematically for different orders and different cut-off frequencies"
      extends Modelica.Icons.Example;
      DifferentInitialization normalized(normalized=true)
        annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
      DifferentInitialization notNormalized(normalized=false)
        annotation (Placement(transformation(extent={{-60,0},{-40,20}})));
      Basic basicWithGain(gain=1.4)
        annotation (Placement(transformation(extent={{-20,40},{0,60}})));
      annotation (experiment(StopTime=1.1));
    end AllOptions;

    model Basic
      extends Modelica.Blocks.Icons.Block;
      parameter Integer order1=3;
      parameter Integer order2=6;
      parameter Modelica.SIunits.Frequency f_cut1=3;
      parameter Modelica.SIunits.Frequency f_cut2=5;
      parameter Boolean normalized=true;
      parameter Modelica.Blocks.Types.FilterType filterType=Modelica.Blocks.Types.FilterType.LowPass
        "Type of filter (LowPass/HighPass)";
      parameter Modelica.Blocks.Types.Init init=Modelica.Blocks.Types.Init.SteadyState
        "Type of initialization (no init/steady state/initial state/initial output)";

      Modelica.Blocks.Sources.Step step(startTime=0.1, offset=0.1)
        annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
      Modelica.Blocks.Continuous.Filter CriticalDamping_a(
        analogFilter=Modelica.Blocks.Types.AnalogFilter.CriticalDamping,
        normalized=normalized,
        order=order1,
        f_cut=f_cut1,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut1,
        gain=gain)
        annotation (Placement(transformation(extent={{-20,40},{0,60}})));
      Modelica.Blocks.Continuous.Filter CriticalDamping_b(
        analogFilter=Modelica.Blocks.Types.AnalogFilter.CriticalDamping,
        normalized=normalized,
        order=order2,
        f_cut=f_cut2,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut2,
        gain=gain)
        annotation (Placement(transformation(extent={{40,40},{60,60}})));
      Modelica.Blocks.Continuous.Filter Bessel_a(
        normalized=normalized,
        order=order1,
        f_cut=f_cut1,
        analogFilter=Modelica.Blocks.Types.AnalogFilter.Bessel,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut1,
        gain=gain)
        annotation (Placement(transformation(extent={{-20,0},{0,20}})));
      Modelica.Blocks.Continuous.Filter Bessel_b(
        normalized=normalized,
        order=order2,
        f_cut=f_cut2,
        analogFilter=Modelica.Blocks.Types.AnalogFilter.Bessel,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut2,
        gain=gain)
        annotation (Placement(transformation(extent={{40,0},{60,20}})));
      Modelica.Blocks.Continuous.Filter Butterworth_a(
        normalized=normalized,
        order=order1,
        f_cut=f_cut1,
        analogFilter=Modelica.Blocks.Types.AnalogFilter.Butterworth,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut1,
        gain=gain)
        annotation (Placement(transformation(extent={{-20,-40},{0,-20}})));
      Modelica.Blocks.Continuous.Filter Butterworth_b(
        normalized=normalized,
        order=order2,
        f_cut=f_cut2,
        analogFilter=Modelica.Blocks.Types.AnalogFilter.Butterworth,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut2,
        gain=gain)
        annotation (Placement(transformation(extent={{40,-40},{60,-20}})));
      Modelica.Blocks.Continuous.Filter ChebyshevI_a(
        normalized=normalized,
        order=order1,
        f_cut=f_cut1,
        analogFilter=Modelica.Blocks.Types.AnalogFilter.ChebyshevI,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut1,
        gain=gain)
        annotation (Placement(transformation(extent={{-20,-80},{0,-60}})));
      Modelica.Blocks.Continuous.Filter ChebyshevI_b(
        normalized=normalized,
        order=order2,
        f_cut=f_cut2,
        analogFilter=Modelica.Blocks.Types.AnalogFilter.ChebyshevI,
        init=init,
        filterType=filterType,
        f_min=0.8*f_cut2,
        gain=gain)
        annotation (Placement(transformation(extent={{40,-80},{60,-60}})));

      parameter Real gain=1.0
        "Gain (= amplitude of frequency response at zero frequency)";
    equation
      connect(step.y, CriticalDamping_a.u) annotation (Line(
          points={{-39,50},{-22,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(step.y, CriticalDamping_b.u) annotation (Line(
          points={{-39,50},{-32,50},{-32,70},{20,70},{20,50},{38,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(step.y, Bessel_a.u) annotation (Line(
          points={{-39,50},{-32,50},{-32,10},{-22,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(step.y, Bessel_b.u) annotation (Line(
          points={{-39,50},{-32,50},{-32,70},{20,70},{20,10},{38,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(Butterworth_a.u, step.y) annotation (Line(
          points={{-22,-30},{-32,-30},{-32,50},{-39,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(step.y, Butterworth_b.u) annotation (Line(
          points={{-39,50},{-32,50},{-32,70},{20,70},{20,-30},{38,-30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(ChebyshevI_a.u, step.y) annotation (Line(
          points={{-22,-70},{-32,-70},{-32,50},{-39,50}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(step.y, ChebyshevI_b.u) annotation (Line(
          points={{-39,50},{-32,50},{-32,70},{20,70},{20,-70},{38,-70}},
          color={0,0,127},
          smooth=Smooth.None));
      annotation (experiment(StopTime=0.9), Icon(graphics={Text(
                  extent={{-82,54},{86,22}},
                  lineColor={0,0,0},
                  textString="basic"),Text(
                  extent={{-84,2},{84,-30}},
                  lineColor={0,0,0},
                  textString="filters")}));
    end Basic;

    block DifferentFilterTypes
      extends Modelica.Blocks.Icons.Block;
      Basic lowPass(
        filterType=Modelica.Blocks.Types.FilterType.LowPass,
        normalized=normalized,
        init=init)
        annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
      Basic highPass(
        filterType=Modelica.Blocks.Types.FilterType.HighPass,
        normalized=normalized,
        init=init)
        annotation (Placement(transformation(extent={{-60,0},{-40,20}})));
      Basic bandPass(
        filterType=Modelica.Blocks.Types.FilterType.BandPass,
        normalized=normalized,
        init=init,
        order1=4,
        order2=10)
        annotation (Placement(transformation(extent={{-60,-40},{-40,-20}})));
      Basic bandStop(
        filterType=Modelica.Blocks.Types.FilterType.BandStop,
        normalized=normalized,
        init=init,
        order1=4,
        order2=10)
        annotation (Placement(transformation(extent={{-60,-80},{-40,-60}})));
      parameter Modelica.Blocks.Types.Init init=Modelica.Blocks.Types.Init.SteadyState
        "Type of initialization (no init/steady state/initial state/initial output)";
      parameter Boolean normalized=true;
    end DifferentFilterTypes;

    block DifferentInitialization
      extends Modelica.Blocks.Icons.Block;
      DifferentFilterTypes steadyState(init=Modelica.Blocks.Types.Init.SteadyState,
          normalized=normalized)
        annotation (Placement(transformation(extent={{-60,40},{-40,60}})));
      DifferentFilterTypes initialState(init=Modelica.Blocks.Types.Init.InitialState,
          normalized=normalized)
        annotation (Placement(transformation(extent={{-60,0},{-40,20}})));
      DifferentFilterTypes initialOutput(init=Modelica.Blocks.Types.Init.InitialOutput,
          normalized=normalized)
        annotation (Placement(transformation(extent={{-60,-40},{-40,-20}})));
      DifferentFilterTypes noInit(init=Modelica.Blocks.Types.Init.InitialOutput,
          normalized=normalized)
        annotation (Placement(transformation(extent={{-60,-80},{-40,-60}})));
      parameter Boolean normalized=true;
    equation

    end DifferentInitialization;
  end FilterTests;
end Blocks;
